
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  interface iCondition
  {
    public bool Evaluate();
  }

  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Condition.svg")]
  public partial class Condition:Resource, iCondition
  {
    public virtual bool Evaluate()
    {
      return true;
    }

    public static bool Evaluate( Condition condition )
    {
      return condition == null ? false : condition.Evaluate();
    }
  }
}