
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/Condition.svg")]
  public partial class DistanceCondition: SceneCondition
  {
    [Export]
    public Node3D from;

    [Export]
    public Node3D to;

    [Export]
    public float distance;
    
    public override bool Evaluate()
    {
      if ( from == null || to == null || distance < 0 )
      {
        return false;
      }

      return from.IsInRange( to, distance );
    }

  }
}