using System.Collections;
using System.Collections.Generic;
using System.Text;
using System;
using System.Linq;


namespace Rokojori
{  

  public class ReadonlyEventProperty<T>: EventSlot<T>
  {
    protected T _value;
    public T value
    {
      get { return _value; }
      protected set { }
    }    
  }  

  public class EventProperty<T>:ReadonlyEventProperty<T>
  {
    public new T value
    {
      get { return _value; }
      set 
      { 
        if ( IsEqual( _value, value ) )
        {
          return;
        }

        _value = value; 
        DispatchEvent();
      }
    }

    public virtual void DispatchEvent()
    {
      _canModify = false;

       _actions.ForEach( a => { if ( a != null ){ a( _value ); } } );
      
      _UpdateLists();

      _canModify = true;
    }
    

    protected bool IsEqual( T oldValue, T newValue )
    {
      if ( oldValue == null && newValue == null )
      {
        return true;
      }

      if ( oldValue == null || newValue == null )
      {
        return false;
      }

      if ( EqualityComparer<T>.Default.Equals( oldValue , newValue ) )
      {
        return true;
      }

      return false;
    }

    public void SetSilent( T value )
    {
      _value = value;
    }
  }


}
