
using System.Collections.Generic;

using Godot;

namespace Rokojori
{   
  public static class Signals
  {
    public static void OnFinished( this GpuParticles3D particles3D, System.Action action, bool once = false )
    {
      if ( once )
      {
        _OnSignalOnce( particles3D, GpuParticles3D.SignalName.Finished, action );
      }
      else
      {
        _OnSignal( particles3D, GpuParticles3D.SignalName.Finished, action );
      }     
    }

    public static void OnFinishedOnce( this GpuParticles3D particles3D, System.Action action )
    {
      OnFinished( particles3D, action, true );
    }

    public static void _OnSignal( this Node node, string name, System.Action action )
    {
      node.Connect( name, Callable.From( action ) );
    }

    public static void _OnSignal( this Node node, string name, Callable callable )
    {
      node.Connect( name, callable );
    }


    public static void _OnSignalOnce( this Node node, string name, System.Action action )
    {
      Callable? onceAction = null;
      
      onceAction = Callable.From( 
        ()=>
        {
          action();
          node.Disconnect( name, (Callable) onceAction );
        }
      );

      node.Connect( name, (Callable) onceAction );
    }
  }
}