using Godot;
using System.Reflection;
using System.Collections.Generic;
using System.Text;

namespace Rokojori
{ 
  public static class GDScriptNames
  { 
    public static bool IsOrExtendsFrom( Node node, string className )
    {
      if ( node == null )
      {
        return false;
      }

      if ( node.IsClass( className ) )
      {
        return true;
      }

      var script = (Script) node.GetScript();

      while ( script != null )
      {
        if ( ExtractClassName( script ) == className )
        {
          return true;
        }

        script = script.GetBaseScript();
      } 

      return false;
      
    } 

    public static string ExtractClassName( Script script )
    {
      if ( script != null )
      {
        var className = script.GetClass();

        if ( className != "GDScript" )
        {
          if ( className == "CSharpScript" )
          {
            return null;
          }

          return className;
        }



        var scriptPath = script.ResourcePath;

        className = System.IO.Path.GetFileNameWithoutExtension( scriptPath );
        return className;
      }

      return "GDScript";
    }

    public static string ExtractClassName( Node node )
    {
      if ( node == null )
      {
        return null;
      }

      var script = (Script) node.GetScript();

      return ExtractClassName( script );
    }
    public static string ToCS( string gdScriptName )
    {
      return gdScriptName.ToPascalCase();
    }

    public static string FromCS( string csName )
    {
      return csName.ToSnakeCase();
    }

    
  }

}