
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Linq;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/GameObject3D.svg") ]
  public partial class GameObject3D:Node3D, INetworkNode
  { 
    [ExportToolButton("Center On Children")]
    public Callable centerOnChildrenButton => Callable.From( ()=> { this.CenterOnChildren(); }  );

    [ExportToolButton("Floor Pivot")]
    public Callable floorPivotButton => Callable.From( ()=> { this.FloorPivot(); }  );

    [ExportGroup("Physics")]
    [Export]
    public PhysicsBody3D body;

    [Export]
    public Node3D origin;

    [ExportCategory("Networking")]
    [ExportGroup("Network Settings")]
    [Export]
    public NetworkTransportType networkType = NetworkTransportType.Never_Networked;
    public NetworkTransportType GetNetworkType(){ return networkType; }
 
    [Export]
    public int networkOwner;
    public int GetNetworkOwner(){ return networkOwner; }

    
    protected List<NetworkNodeMember> _networkNodeMembers = null;
    protected NetworkNodeSlot _networkNodeSlot = new NetworkNodeSlot();

    public virtual List<NetworkNodeMember> GetNetworkNodeMembers()
    {
      if ( _networkNodeMembers != null )
      {
        return _networkNodeMembers;
      }

      _networkNodeMembers = CreateNetworkNodeMembers();
      _networkNodeSlot.onMessage.AddAction( _OnNetworkMessageReceived );

      InitializeNetworkMembers();

      return _networkNodeMembers;
    }

    protected virtual List<NetworkNodeMember> CreateNetworkNodeMembers()
    {
      return new List<NetworkNodeMember>(){ _networkNodeSlot };
    }

    protected virtual void InitializeNetworkMembers()
    {
      for ( int i = 0; i < _networkNodeMembers.Count; i++ )
      {
        _networkNodeMembers[ i ]._SetNode( this );
      }
    }

    protected virtual void _OnNetworkMessageReceived( NetworkMessageEvent m )
    {

    }
  }
}