
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Linq;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/NodeContainer.svg") ]
  public partial class NodeContainer:NetworkNode
  { 
    #if TOOLS

    [ExportToolButton( "Enable All Children")]
    public Callable enableAllButton => Callable.From(
      ()=>
      {
        this.ForEach<Node>( n => n.Enable() );
      }
    );

    [ExportToolButton( "Disable All Children")]
    public Callable disableAllButton => Callable.From(
      ()=>
      {
        this.ForEach<Node>( n => n.Disable() );
      }
    );

    [ExportToolButton( "Show All Children")]
    public Callable showAllButton => Callable.From(
      ()=>
      {
        this.ForEach<Node>( n => n.SetVisibility( true ) );
      }
    );

    [ExportToolButton( "Hide All Children")]
    public Callable hideAllButton => Callable.From(
      ()=>
      {
        this.ForEach<Node>( n => n.SetVisibility( false ) );
      }
    );

    #endif
  }
}