
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Linq;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/GameObject.svg") ]
  public partial class IntVariable:Node
  { 
    [Export]
    public IntVariableClass variableClass;

    int _value = 0;

    [Export]
    public int value
    {
      get => _value; 

      set
      {
        if ( variableClass == null )
        {
          _value = value;
          return;
        }

        var valueBefore = _value;
        var valueNew = variableClass.SetValue( this, valueBefore, value );

        if ( valueBefore == valueNew )
        {
          return;
        }

        onChange?.Trigger();
        
        if ( valueNew > valueBefore )
        {
          onIncrease?.Trigger();
        }
        else if ( valueNew < valueBefore )
        {
          onDecrease?.Trigger();
        }

        if ( valueNew == variableClass.min )
        {
          onMin?.Trigger();
        }

        if ( valueNew == variableClass.max )
        {
          onMax?.Trigger();
        }


      }
    }

    [Export]
    public Action onChange;

    [Export]
    public Action onIncrease;

    [Export]
    public Action onDecrease;

    [Export]
    public Action onMax;

    [Export]
    public Action onMin;
  }
}