
using System.Diagnostics;
using System.Collections;
using System.Collections.Generic;
using System;
using Godot;
using System.Linq;


namespace Rokojori
{  
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/GameObject.svg") ]
  public partial class IntVariableClass:Resource
  { 
    [Export]
    public int min = -1000000;

    [Export]
    public int max = 1000000;

    [Export]
    public int resetValue = 0;


    public int ResetValue( IntVariable variable, int currentValue )
    {
      return resetValue;
    }

    public int SetValue( IntVariable variable, int valueBefore, int valueNew )
    {
      return Mathf.Clamp( valueNew, min, max );
    }
  }
}