using Godot;
using System.Text;
using System.Collections.Generic;
using System;

namespace Rokojori
{  
  public class CachedResource<T> where T:Resource
  {
    protected T _resource;
    protected string _path;
    public string path => _path;
    protected Func<Resource,T> _converter;

    public CachedResource( string path, Func<Resource,T> converter = null )
    {
      _path = path;
      _converter = converter;
    }

    public T Get()
    {
      if ( _resource == null )
      {
      
        _resource = _converter == null ? 
                    ResourceLoader.Load<T>( _path ) : 
                    _converter( ResourceLoader.Load( _path ) );

        // RJLog.Log( _path, _resource );

      
      }

      return _resource;
    }
  }
}