using Godot;
using System.Text;
using System.Collections.Generic;

namespace Rokojori
{ 
  public class SerializedGodotCurve: GodotBuiltInSerializer
  {     
    public override bool Handles( object obj )
    {
      return obj as Curve != null;
    }

    public override object Serialize( object obj )
    {
      if ( obj == null )
      {
        return null;
      }

      var curve = obj as Curve;

      var curveData = new List<float>();

      for ( int i = 0; i < curve.PointCount; i++ )
      {
        if ( i != 0 )
        { 
          curveData.Add( curve.GetPointLeftTangent( i ) ); 
        }

        curveData.Add( curve.GetPointPosition( i ).X );
        curveData.Add( curve.GetPointPosition( i ).Y );

        if ( i != curve.PointCount -1 )
        {
          curveData.Add( curve.GetPointRightTangent( i ) );
        }
      }

      return curveData;
    }
  }
}