using Godot;
using System.Text;
using System.Collections.Generic;

namespace Rokojori
{ 
  public class TransformChange
  {
    Vector3 position = Vector3.Zero;
    Quaternion rotation = Quaternion.Identity;
    Vector3 scale = Vector3.One;


    public bool Check( Node3D source )
    {
      var changed = false;

      if ( position != source.GlobalPosition )
      {
        changed = true;
        position = source.GlobalPosition;
        
      }

      var sourceRotation = source.GlobalQuaternion();

      if ( rotation != sourceRotation )
      {
        changed = true;
        rotation = sourceRotation;
      }

      if ( scale != source.Scale )
      {
        changed = true;
        scale = source.Scale;
      }

      return changed;
    }

  }
}