using Godot;

using System.Collections.Generic;
using System;
using System.Threading.Tasks;
using System.Reflection;
using Microsoft.VisualBasic;

namespace Rokojori
{  
  public static class NodeExtensions
  {
    public static T GetNextSiblingOrChild<T>( this Node node ) where T:Node
    {
      var index = node.GetIndex();
      var p = node.GetParent();

      for ( int i = index + 1; i < p.GetChildCount(); i++ )
      {
        var child = p.GetChild( i );
        
        if ( child != null && child is T t )        
        {
          return t;
        }
      }

      return Nodes.GetAnyChild<T>( node );
    }

  }
}
