using Godot;
using System.Text;
using System.Collections.Generic;

namespace Rokojori
{
  public class GodotEditorHelper
  {
    public static string AbsoluteToResourcePath( string path )
    {    
      #if TOOLS 

      if ( path != null )
      {
        return ProjectSettings.LocalizePath( path );
      }

      #endif

      return path;
    }

    public static bool IsProjectPath( string path )
    {
      return path.StartsWith( "res://" ) || path.StartsWith( "user://" );
    }

    public static void UpdateFile( string path )
    {
      #if TOOLS 

      if ( ! IsProjectPath( path ) )
      {
        var pathBefore = path;
        path = AbsoluteToResourcePath( path );
        RJLog.Log( "Converted path", pathBefore, ">>", path ); 
      }

      var filesystem = EditorInterface.Singleton.GetResourceFilesystem();
      filesystem.ReimportFiles( [ path ] );

      filesystem.UpdateFile( path );

      if ( path.ToLower().EndsWith( "gdshader" ) )
      {
        var shader = ResourceLoader.Load<Shader>( path, null, ResourceLoader.CacheMode.Ignore );
        EditorInterface.Singleton.EditResource( shader );
      }

      #endif
    }
  }
}