using Godot;
using System.Text;
using System.Collections.Generic;

namespace Rokojori
{  
  public class MakeResourcesUnique
  {
    public static void On( Node node )
    {
      var resourceFields = ReflectionHelper.GetFieldInfosOfType<Resource>( node );

      for ( int i = 0; i < resourceFields.Count; i++ )
      {
        var rf = resourceFields[ i ];
        var resource = (Resource) rf.GetValue( node );
        var value = resource.Duplicate( true );

        rf.SetValue( node, value );
      }
    }
  }
}