using Godot;


namespace Rokojori
{  
  public class NodesWalker: TreeWalker<Node>
  { 
    static NodesWalker _singleton = new NodesWalker();
    public static NodesWalker Get() 
    {
      return _singleton;
    }

    public override Node Parent( Node n )
    {
      if ( n == null )
      {
        return null;
      }

      return n.GetParent();
    }

    public override Node ChildAt( Node n, int index )
    {
      if ( n == null )
      {
        return null;
      }

      return n.GetChild( index );
    }

    public override int NumChildren( Node n )
    {
      if ( n == null )
      {
        return 0;
      }

      return n.GetChildCount();
    }

   
  }
}