using Godot;

using System.Collections.Generic;
using System;
using System.Threading.Tasks;
using System.Reflection;
using Microsoft.VisualBasic;

namespace Rokojori
{  
  public static class ResourceExtensions
  {
    
    
    public static Error SaveAs( this Resource resource, string savePath, bool forceUpdate = false, ResourceSaver.SaverFlags saverFlags = ResourceSaver.SaverFlags.None )
    {
      #if ! TOOLS
      
      return Error.Unavailable;

      #else 
      var error = ResourceSaver.Save( resource, savePath, saverFlags );
      
      if ( forceUpdate )
      {
        EditorInterface.Singleton.GetResourceFilesystem().Scan();
      }

      return error;

      #endif
    }

    
  }
}
