using System;
using Godot;


namespace Rokojori
{  
  [Tool]
  public partial class Root:Node
  {
    private static Root _singleton;

    public override void _Ready()
    {
      _singleton = this;
    }

    public static SceneTree Tree()
    {
      if ( _singleton == null )
      {
        return null;
      }

      return _singleton.GetTree();
    }

    public static Window Window()
    {
      var tree = Tree();

      if ( tree == null)
      {
        return null;
      }

      return tree.Root;
    }

    static Root Get()
    {
      var r = Window();

      return _singleton;
    }


    #if TOOLS 

    public override void _Process( double delta )
    {
      if ( ! Engine.IsEditorHint() )
      {
        return;
      }

      CheckWarnings();

    }

    int step = 0;

    void CheckWarnings()
    {
      var walker = NodesWalker.Get();

      for ( int i = 0; i < numNodeTests; i++ )
      {
        if ( _iterationNode == null || ! IsInstanceValid( _iterationNode ) )
        {         
          _iterationNode = EditorInterface.Singleton.GetEditedSceneRoot();
        }
        else
        {
          _iterationNode = walker.NextNode( _iterationNode );
        }        

        UpdateWarning( _iterationNode ); 
      }
    }

    Node _iterationNode = null; 
    int numNodeTests = 100;

    void UpdateWarning( Node n )
    {
      if ( n == null )
      {
        return;
      }

      n.UpdateConfigurationWarnings();
    }

    #endif  
  }
}