using Godot;

using System;
using System.Collections.Generic;

namespace Rokojori
{  
  public class SceneFileHTMLScriptJS
  {
    public static string script = 
    @"
        function main()
        {
          let elements = document.querySelectorAll( '.closeable' );

          for ( let i = 0; i < elements.length; i++ )
          {
            let element = elements[ i ];

            element.addEventListener( 'click', 
              ( ev )=>
              {
                
                let target = element.getAttribute( 'data-close-target' ); 

                let targetElement = element;

                let parentRegex = /^\.\.\s/;

                while ( parentRegex.test( target ) )
                {
                  target = target.replace( parentRegex, '' );
                  targetElement = targetElement.parentElement;
                }

                let rootRegex = /^\.\.\.\s/;

                if ( rootRegex.test( target ) )
                {
                  target = target.replace( rootRegex, '' );
                  targetElement = document.documentElement;
                }

                let closeTarget = element.parentElement.querySelector( target );

                console.log( ev, target, closeTarget);
                closeTarget.style.display = closeTarget.style.display === 'none' ? 'block' : 'none';

                element.setAttribute( 'data-close-state', closeTarget.style.display );

                ev.preventDefault();
                return false;
              },
              true 
            );
          }

          let references = document.querySelectorAll( 'gd-reference' );

          for ( let i = 0; i < references.length; i++ )
          {
            let reference = references[ i ];

            reference.addEventListener( 'click', 
              ( ev )=>
              {
                let ref = reference.getAttribute( 'reference' );
                let selector = `[id=##${ref}##]`;

                console.log( 'querying', selector );
                let referenced = document.querySelector( selector );

                referenced.scrollIntoView( { 'behavior': 'smooth' });
              }
            );
          }


        }

        window.addEventListener( 'load', () => { main(); });
    
    
    ".Replace( "##", "\"");
  }
}