using Godot;
using System.Collections.Generic;

namespace Rokojori
{
  public class NodeSFO:SceneFileObject
  {
    public static readonly  string headerType = "node";


    protected NodeSFO _parentObject;
    public readonly SFHStringAttribute name   = new SFHStringAttribute( "name" );
    public readonly SFHStringAttribute parent = new SFHStringAttribute( "parent" );
    public readonly SFHStringAttribute type   = new SFHStringAttribute( "type" );
    protected string _elementPath;
    public string elementPath => _elementPath;


    protected override void _CreateFromHeaderEntry( SceneFileEntry headerEntry )
    {
      _elementPath = name.value;
      var parentPath = parent.value;

      if ( parentPath == null )
      {
        _elementPath = ".";
      }
      else 
      {
        if ( parentPath != "." )
        {
          _elementPath = parentPath + "/" + name.value;
        }            
      }
    }

    public void ResolveParent( Dictionary<string,NodeSFO> nodeMap, NodeSFO rootNode )
    {
      var parentPath = parent.value;

      if ( parentPath == "." )
      {
        _parentObject = rootNode;
        return;
      }

      if ( parentPath != "." && parentPath != null )
      { 
        if ( nodeMap.ContainsKey( parentPath ) )
        {
          _parentObject = nodeMap[ parentPath ];
        }
        else
        {
          RJLog.Log( "Parent not found:", name.value, parentPath, elementPath );
        }            
      }
    }
  }
}