using Godot;
using System.Collections.Generic;

namespace Rokojori
{
  public class SceneFileObject
  {
    protected SceneFileEntry _headerEntry;
    protected List<SceneFileHeaderAttributeValue> _attributes = new List<SceneFileHeaderAttributeValue>();
    protected List<SceneFileEntry> _data = new List<SceneFileEntry>();

    public List<SceneFileEntry> data => _data;

    public SceneFileObject()
    {
      SetAttributes();
    }

    public SceneFileNamedValue GetMember( string name )
    {
      var entry = _data.Find( d => d.member != null && d.member.name == name );
      return entry == null ? null : entry.member;
    }


    public void AddData( SceneFileEntry se )
    {
      if ( SceneFileLinesLexer.SeperatorMatcher.Matches( se.type ) )
      {
        return;
      }      

      _data.Add( se );
    }

    public void CreateFromHeaderEntry( SceneFileEntry headerEntry )
    {
      ReadAttributes( headerEntry.header );

      _CreateFromHeaderEntry( headerEntry );
    }
    
    protected virtual void _CreateFromHeaderEntry( SceneFileEntry headerEntry )
    {

    }

    protected virtual void SetAttributes()
    {
      _attributes = ReflectionHelper.GetFieldValuesOfType<SceneFileHeaderAttributeValue>( this );
    }

    protected void ReadAttributes( SceneFileHeader entry )
    {
      _attributes.ForEach( a => a.GetValue( entry ) );
    }
  }
}