using Godot;
using System.Collections.Generic;
using System;

namespace Rokojori
{
  public class SceneFileObjectFactory
  {
    static Dictionary<string,Func<SceneFileObject>> factory = 
     new Dictionary<string,Func<SceneFileObject>>()
     {
       { GDSceneSFO.headerType, () => new GDSceneSFO() },
       { ExtResourceSFO.headerType, () => new ExtResourceSFO() },
       { SubResourceSFO.headerType, () => new SubResourceSFO() },
       { NodeSFO.headerType, () => new NodeSFO() },
       { EditableSFO.headerType, () => new EditableSFO() }
     }; 

    public static SceneFileObject Create( SceneFileEntry entry )
    {
      if ( entry.header == null )
      {
        RJLog.Log( "Has no header >>", entry.line );
        return null;
      }

      foreach ( var vk in factory )
      {
        if ( entry.IsHeaderType( vk.Key ) )
        {
          var sfo = vk.Value();
          sfo.CreateFromHeaderEntry( entry );

          return sfo;
        }
      }

      RJLog.Log( "Unknown header type >> ", entry.header.type, ":", entry.line );
      return null;
    }
  }
}