using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

namespace Rokojori
{  
  public class SceneFileLinesLexer:Lexer
  {
    public static List<LexerEvent> Lex( string source )
    {
      var lexer = new SceneFileLinesLexer();
      var events = lexer.LexToList( source );      

      if ( lexer.hasError )
      {
        return null;
      }

      events.ForEach( ev => { ev.GrabMatch( source ); } );


      return events;
    }

    public static readonly LexerMatcher HeaderMatcher = LexerMatcher.CreateExtended(
      "Header", "\\[.+\\]"
    );

    public static readonly LexerMatcher SeperatorMatcher = LexerMatcher.CreateExtended(
      "Seperator", "\\l\\l"
    );

    // ((?:\w|_|\/)+) = .+?(\r\n|\r|\n)
    // ((?:\\w|_|\\/)+) = .+?(\\r\\n|\\r|\\n)
    public static readonly LexerMatcher MemberMatcher = LexerMatcher.CreateExtended(
      "Member", "(?:\\w|_|\\/)+ = .+?"
    );

    // ".+?"\: .+?,(\r\n|\r|\n)
    // \".+?\"\\: .+?,\\l
    public static readonly LexerMatcher SubMemberMatcher = LexerMatcher.CreateExtended( 
      "SubMember", "\".+?\"\\: .+?"
    );

    public static readonly LexerMatcher SubMemberStartMatcher = LexerMatcher.CreateExtended( 
      "SubMemberStart", ".+\\[\\{"
    );

    public static readonly LexerMatcher SubMemberEndMatcher = LexerMatcher.CreateExtended( 
      "SubMemberEnd", "\\}\\]"
    );

    public SceneFileLinesLexer()
    {
      AddAllMatchers( 
        SceneFileLinesLexer.HeaderMatcher,
        SceneFileLinesLexer.SeperatorMatcher,
        SceneFileLinesLexer.SubMemberStartMatcher,
        SceneFileLinesLexer.SubMemberEndMatcher,
        SceneFileLinesLexer.SubMemberMatcher,
        SceneFileLinesLexer.MemberMatcher,
        LexerMatcherLibrary.AnySymbolMatcher
      );
    }
  }
}