using Godot;
using System.Collections.Generic;

namespace Rokojori
{  
  public class SceneFileParser
  {
    public string source;
    public SceneFile sceneFile;

    public void Parse( string source )
    {
      this.source = source;

      var lines = RegexUtility.SplitLines( source );
      var lexer = new SceneFileLinesLexer();

      var lineIndex = 1;

      sceneFile = new SceneFile();

      lines.ForEach(
        ( ln )=>
        {
          var matcher = lexer.GetMatcher( ln );

          if ( matcher == null )
          {
            sceneFile.entries.Add( SceneFile.Seperator() );
          }
          else
          {
            var linePreview = ln;            
            sceneFile.entries.Add( SceneFile.Create( matcher.type, ln ) );
          }
          

          lineIndex ++;
        }
      );

      sceneFile.CreateObjects();

    }
  }
}