using Godot;
using System.Collections.Generic;

namespace Rokojori
{ 
  public class SceneFileEntry
  {
    public string type;
    public string line;
    public SceneFileHeader header;
    public SceneFileNamedValue member;
    public SceneFileNamedValue subMember;
    public bool hasError = false;


    public bool hasHeader => header != null;

    public bool IsHeaderType( string type )
    {
      return header != null && header.type == type;
    }

    public void Parse()
    {
      if ( type == SceneFileLinesLexer.HeaderMatcher.type )
      {
        var headerParser = new SceneFileHeaderParser();
        headerParser.Parse( this );

        if ( headerParser.hasError )
        {
          hasError = true;
        }
      }
      else if ( type == SceneFileLinesLexer.MemberMatcher.type )
      {
        var memberParser = new SceneFileMemberParser();
        memberParser.Parse( this );

        if ( memberParser.hasError )
        {
          hasError = true;
        }
      }
    }
  }

}