using Godot;

using System;
using System.Collections.Generic;

namespace Rokojori
{  
  [Tool]
  [GlobalClass]
  public partial class SceneFileReader:Node
  {
    [Export]
    public string path = "";

    [ExportToolButton( "Read" )]
    public Callable ReadButton => Callable.From( 
      ()=>
      {
        LoadScene(); 
      }
    );

    [Export]
    public bool exportJSON = false;

    [Export]
    public bool exportHTML = false;

    void LoadScene()
    {

      var text = FilesSync.LoadUTF8( ProjectSettings.GlobalizePath( path ) );

      var parser = new SceneFileParser();

      parser.Parse( text );

      if ( exportJSON )
      {
        FilesSync.SaveJSON( path + ".json", parser.sceneFile.GetSerializableJSONVersion() );
      }

      if ( exportHTML )
      {
        var exporter = new SceneFileHTMLExporter();
        exporter.ParseAndExport( parser, path );
      }

    }
  
  }
}