using System.Collections;
using System.Collections.Generic;

using Godot;

namespace Rokojori
{
  public class Unique<N> where N:Node
  {
    private static N _singleton;

    public static N Get( Node n = null )
    {
      // RJLog.Log( typeof( N ).Name );

      if ( _singleton != null )
      {
        return _singleton;
      }      

      var rootWindow = n == null ? Root.Window() : n.Owner;      

      if ( rootWindow == null )
      {
        if ( Engine.IsEditorHint() )
        {
          #if TOOLS
          rootWindow = EditorInterface.Singleton.GetEditedSceneRoot();
          #endif
        }
        else
        {
          return null;
        }        
      }

      _singleton = Nodes.GetAnyChild<N>( rootWindow );

      if ( _singleton == null )
      {
        if ( Engine.IsEditorHint() )
        {
          #if TOOLS
          rootWindow = EditorInterface.Singleton.GetEditedSceneRoot();
          #endif
          _singleton = Nodes.GetAnyChild<N>( rootWindow );
        }
      }
      
      return _singleton;
    }

   
  }
}