using System.Collections;
using System.Collections.Generic;
using System;

namespace Rokojori
{
  public class Graph<N>:GraphWalker<N> where N:class
  {
    List<N> _nodes = [];

    public Graph( List<N> nodes )
    {
      _nodes = nodes;
    }

    List<GraphConnection<N>> _connections = [];
    MapList<N,N> _fromConnections = new MapList<N, N>();
    MapList<N,N> _toConnections = new MapList<N, N>();


    public void Connect( N from, N to )
    {
      var c = new GraphConnection<N>();
      c.from = from;
      c.to = to;
      _connections.Add( c );

      _toConnections.Add( from, to );
      _fromConnections.Add( to, from );
    }

    public override int NumConnectedTo( N n )
    {
      if ( ! _toConnections.ContainsKey( n ) )
      {
        return 0;
      }

      return _toConnections[ n ].Count;
    }

    public override N GetConnectedTo( N n, int index )
    {
      if ( ! _toConnections.ContainsKey( n ) )
      {
        return null;
      }
      
      return _toConnections[ n ][ index ] ;
    }

    public override int NumConnectedFrom( N n )
    {
      if ( ! _fromConnections.ContainsKey( n ) )
      {
        return 0;
      }

      return _fromConnections[ n ].Count;
    }

    public override N GetConnectedFrom( N n, int index )
    {
      if ( ! _fromConnections.ContainsKey( n ) )
      {
        return null;
      }
      
      return _fromConnections[ n ][ index ] ;
    }

    public List<N> ComputeOrder()
    {
      return ComputeOrder( _nodes );
    }
  }
}