using System.Collections;
using System.Collections.Generic;
using System;

namespace Rokojori
{
  public class CustomTreeWalker<N>:TreeWalker<N> where N:class
  {
    Func<N,N> _getParent;
    Func<N,int,N> _childAt;
    Func<N,int> _numChildren;
    

    public CustomTreeWalker( Func<N,N> getParent, Func<N,int,N> childAt, Func<N,int> numChildren  )
    { 
      _getParent = getParent;
       _childAt = childAt;
      _numChildren = numChildren;
     
    }

    public override N Parent( N node ){ return _getParent( node ); }
    
    public override N ChildAt( N node, int index ){ return _childAt( node, index ); }
    
    public override int NumChildren( N node ){ return _numChildren( node ); }
  }
}