using System.Collections;
using System.Collections.Generic;


namespace Rokojori
{
  public class ChildrenIterator<N>: TreeIterator<N> where N:class
  {
    N parent;
    N current;
    N end;
    N next;
    TreeWalker<N> walker;
    
    public static ChildrenIterator<N> Create( TreeWalker<N> walker, N node )
    {
      var iterator = new ChildrenIterator<N>();

      iterator.walker = walker;
      iterator.current = null;
      iterator.parent = node;
      iterator.end = walker.IterationEndOf( node );
      iterator.next = walker.NextNode( node );

      if ( iterator.next == iterator.end )
      {
        iterator.next = null;
      }

      return iterator;
    }

    public override bool HasNext()
    {
      return next != null;
    }

    public override N Current()
    {
      return current;
    } 

    protected override void _MoveToNext()
    {
      current = next;

      next = walker.NextNode( current );

      if ( next == end )
      {
        next = null;
      }
    }

  }
}