using System.Collections;
using System.Collections.Generic;


namespace Rokojori
{
  public class DirectChildrenIterator<N>: TreeIterator<N> where N:class
  {
    N parent;
    N current;
    int index = 0;
    TreeWalker<N> walker;
    
    public static DirectChildrenIterator<N> Create( TreeWalker<N> walker, N node )
    {
      var iterator = new DirectChildrenIterator<N>();

      iterator.parent = node;
      iterator.walker = walker;
      iterator.current = null;
      iterator.index = -1;

      return iterator;
    }

    public override bool HasNext()
    {
      return ( index + 1 ) < walker.NumChildren( parent );
    }

    public override N Current()
    {
      return current;
    } 

    protected override void _MoveToNext()
    {
      index ++;
      current = walker.ChildAt( parent, index );
    }
  }
}