using System.Collections;
using System.Collections.Generic;


namespace Rokojori
{
  public class NodesIterator<N>: TreeIterator<N> where N:class
  {
    N node;
    N current;
    bool isForward = true;
    TreeWalker<N> walker;

    public static NodesIterator<N> Create( TreeWalker<N> walker, N node, bool forward )
    {
      var iterator = new NodesIterator<N>();

      iterator.walker = walker;
      iterator.node = node;
      iterator.current = null;
      iterator.isForward = forward;

      return iterator;
    }

    public override bool HasNext()
    {
      return node != null;
    }

    public override N Current()
    {
      return current;
    } 

    protected override void _MoveToNext()
    {
      if ( isForward )
      {
        node =  walker.NextNode( node );
      }
      else
      {
        node =  walker.PreviousNode( node );
      }

      current = node;
    }
  }
}