using System.Collections;
using System.Collections.Generic;


namespace Rokojori
{
  public class ParentsIterator<N>: TreeIterator<N> where N:class
  {
    N iterator;
    N current;
    TreeWalker<N> walker;
    
    public static ParentsIterator<N> Create( TreeWalker<N> walker, N start )
    {
      var iterator = new ParentsIterator<N>();

      iterator.current = null;
      iterator.iterator = start;
      iterator.walker = walker;

      return iterator;
    }

    public override bool HasNext()
    {
      return walker.HasParent( iterator );
    }

    public override N Current()
    {
      return current;
    } 

    protected override void _MoveToNext()
    {
      iterator = walker.Parent( iterator );
      current = iterator;
    }
  }
}