using System.Collections;
using System.Collections.Generic;


namespace Rokojori
{
  public class SiblingsIterator<N>: TreeIterator<N> where N:class
  {
    bool nextSiblings = true;

    N parent;
    N current;
    int index = 0;
    int nodeIndex = 0;
    TreeWalker<N> walker;

    public static SiblingsIterator<N> Create( TreeWalker<N> walker, N node, bool previous = true, bool next = true )
    {
      var iterator = new SiblingsIterator<N>();

      iterator.parent = node;
      iterator.walker = walker;
      iterator.current = null;     
      iterator.nodeIndex = walker.ChildIndexOf( node );
      iterator.index = previous ? -1 : iterator.nodeIndex;

      return iterator;
    }

    public override bool HasNext()
    {
      if ( ! nextSiblings )
      {
        return ( index + 1 ) < nodeIndex;
      }

      var nextIndex = index + 1;

      if ( nextIndex == nodeIndex )
      {
        nextIndex ++;
      }
      
      return nextIndex < walker.NumChildren( parent );

    }

    public override N Current()
    {
      return current;
    } 

    protected override void _MoveToNext()
    {
      index ++;
      
      if ( index == nodeIndex )
      {
        index ++;
      }

      current = walker.ChildAt( parent, index );
    }
  }
  
}