using System.Collections;
using System.Collections.Generic;


namespace Rokojori
{
  public class SingleIterator<N>: TreeIterator<N> where N:class
  {
    N node;
    N current;

    public static SingleIterator<N> Create( N node )
    {
      var iterator = new SingleIterator<N>();

      iterator.node = node;
      iterator.current = null;

      return iterator;
    }

    public override bool HasNext()
    {
      return node != null;
    }

    public override N Current()
    {
      return current;
    } 

    protected override void _MoveToNext()
    {
      current = node;
      node = null;      
    }
  }
}