using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CharacterControllerAction.svg")]
  public partial class CharacterControllerAction:Action
  {
    [Export]
    public bool enabled = true;

    CharacterController _controller;
    public CharacterController controller => _controller;

    [Export]
    public Condition condition;

    [Export]
    public SceneCondition sceneCondition;

    [Export]
    public CharacterControllerAction[] blockers = [];

    public bool isGrounded => _controller.isGrounded;

    public void SetCharacterController( CharacterController cc )
    {
      _controller = cc;
    }

    public virtual bool HasActiveForces()
    {
      return false;
    }


    public CharacterBody3D body => controller.body;

    public bool blockersActive 
    {
      get
      {
        return blockers != null && blockers.Has( b => b.HasActiveForces() ); 
      }
    }

    public void AddVelocity( Vector3 velocity, float delta = -1 )
    {
      if ( blockersActive )
      {
        return;
      } 

      delta = delta < 0 ? controller.delta : delta;

      body.Velocity += velocity * delta;      
    }

    public void SetScaledVelocity( float scale )
    {
      if ( blockersActive )
      {
        return;
      }

      body.Velocity *= scale;      
    }

    public void SetVelocity( Vector3 velocity, float delta = -1 )
    {      
      if ( blockersActive )
      {
        return;
      }
      
      delta = delta < 0 ? controller.delta : delta;
      body.Velocity = velocity * delta;
    }

    public void Velocity( Vector3 velocity, bool replace, float delta = -1 )
    {
      if ( replace )
      {
        SetVelocity( velocity, delta );
      }
      else
      {
        AddVelocity( velocity, delta );
      }
    }



  }

}