using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass]
  public partial class CharacterIsMoving:SceneCondition
  {
    [Export]
    public CharacterMovement characterMovement;

    [Export]
    public Trillean needsToBeOnFloor = Trillean.Any;


    public override bool Evaluate()
    {
      if ( characterMovement == null )
      {
        return false;
      } 

      if ( ! TrilleanLogic.Matches( needsToBeOnFloor, characterMovement.isOnFloor, true ) )
      {
        return false;
      }

      return characterMovement.isMoving;
    }
  }
}