using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCGravity.svg")]
  public partial class Gravity:CharacterControllerAction
  {
    public static readonly float EarthGravity = 9.80665f;

    [Export]
    public GravityStrength strength;

    [Export]
    public GravityStrength fallingStrength;

    protected override void _OnTrigger()
    {
      if ( isGrounded || strength == null )
      {
        return;
      } 

      var strengthSource = body.Velocity.Y > 0 ||  fallingStrength == null ? strength : fallingStrength;

      AddVelocity( Vector3.Down * strengthSource.GetGravityStrength( this ) );
    }
  }
}