using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCJump.svg")]
  public partial class ReferencedGravityStrength:GravityStrength
  {
    [Export]
    public GravityStrength referencedStrength;

    [Export]
    public float multiplier = 1f;

    public override float GetGravityStrength( Gravity gravity )
    {
      return multiplier * referencedStrength.GetGravityStrength( gravity );
    }
  }
}