using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCGroundReset.svg")]
  public partial class DownGroundingType:GroundingType
  {
    [Export]
    public float downLength = 0.3f;

    [Export]
    public float upOffset = 0f;
    

    protected override bool _IsGrounded( Grounding grounding, List<CollisionData> collisionData )
    {
      var position = grounding.body.GlobalPosition;
      var from = position + upOffset * Vector3.Up;
      var to   = from + Vector3.Down * downLength;

      var hits = PhysicsRayCast.GetAll( collisionData, grounding.body, from, to );

      if ( hits == 0 )
      {
        return false;
      }

      return true;
    }
  }
}