using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCGroundReset.svg")]
  public abstract partial class GroundingType:Resource
  {    
    protected abstract bool _IsGrounded( Grounding grounding, List<CollisionData> collisionData );

    public static bool IsGrounded( Grounding grounding, List<CollisionData> collisionData )
    {
      if ( grounding == null )
      {
        return false;
      }

      if ( grounding.groundingType == null )
      {
        var grounded = grounding.body.IsOnFloor();

        if ( grounded )
        {
          collisionData[ 0 ].CopyFrom( grounding.body.GetLastSlideCollision() );
        }

        return grounded;
      }

      return grounding.groundingType._IsGrounded( grounding, collisionData );
    }
  }
}