using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCJump.svg")]
  public partial class HeightBasedJumpStrength:JumpStrength
  {
    [Export]
    public float height = 1;

    [Export]
    public float airControlAmount = 1f;

    public override float GetJumpStrength( Jump jump )
    {
      var gravityStrength = jump.gravity == null ? Gravity.EarthGravity : 
                            jump.gravity.strength.GetGravityStrength( jump.gravity );

      if ( airControlAmount > 0f )
      {
        var airGravityStrength = jump.airControlGravityStrength.GetGravityStrength( jump.gravity ) * 0.5f;

        gravityStrength -= airGravityStrength * airControlAmount;
      }

      return Mathf.Sqrt( 2f * gravityStrength * height );
    }
  }
}