using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCJump.svg")]
  public partial class HumanJumpStrength:JumpStrength
  {
    public static readonly float HumanAverageStrength = 3;

    [Export]
    public float humanPowerMultiply = 1f;

    public override float GetJumpStrength( Jump jump )
    {
      return HumanJumpStrength.HumanAverageStrength * humanPowerMultiply;
    }
  }
}