using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass, Icon("res://addons/rokojori_action_library/Icons/CCJump.svg")]
  public partial class RawJumpStrength:JumpStrength
  {
    [Export]
    public float jumpImpulseStrength = 200;

    [ExportGroup( "Debug Info")]
    [ExportToolButton( "Compute Height")]
    public Callable computeHeightButton => Callable.From(
      ( )=>
      {
        var y = 0f;
        var v = jumpImpulseStrength;
        var gravity = Gravity.EarthGravity;
        var timeStep = 1f/60f;
        var maxY = y;
        var zeroTime = 0f;
        var maxTime = -1f;

        while ( y >= 0 )
        {
          v -= gravity * timeStep;;
          y += v * timeStep;

          if ( y > maxY )
          {
            maxY = Mathf.Max( y, maxY );
            maxTime = zeroTime;
          }
          
          zeroTime += timeStep; 
        }

        this.LogInfo( "MaxY:", maxY, "Max Time:", maxTime, "Zero Time:", zeroTime );
      }
    );

    public override float GetJumpStrength( Jump jump )
    {
      return jumpImpulseStrength;
    }
  }
}