using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;
using System.Drawing;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Collectable.svg")]
  public partial class Collectable:Action
  {
    [Export]
    public CollectorTypeFlag[] collectorTypeFlags = [];

    [Export]
    public Collidable collidable;

    [Export]
    public CollectableData collectableData;

    [Export]
    public bool isAutoCollectable = true;
    

    [ExportGroup( "On Collected")]
    [Export]
    public Collector collector;
    
    [Export]
    public bool disableOnCollection = true;


    protected override void _OnTrigger()
    {
      if ( collidable == null || collectableData == null )
      {
        RJLog.Log( "No collidable or data" );
        return;
      }

      var collider = collidable.collider;

      if ( collider == null )
      {
        RJLog.Log( "No collider" );
        return;
      }

      var collector = collider.FindSibling<Collector>();

      if ( collector == null )
      {
        RJLog.Log( "No collector" );
        return;
      }

      if ( collectorTypeFlags != null && collectorTypeFlags.Length > 0 )
      {
        if ( collectorTypeFlags.IndexOf( collector.collectorTypeFlag ) == -1 )
        {
          RJLog.Log( "No matching collectorTypeFlags" );
          return;
        }
      }

      var wasCollected = collector.Collect( this );
      
      if ( ! wasCollected )
      {
         RJLog.Log( "! wasCollected" );
        return;
      }

      this.collector = collector;

      if ( disableOnCollection )
      {
        ProcessMode = ProcessModeEnum.Disabled;
      }

      
    }
  }
}
