using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;
using System.Drawing;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Collector.svg")]
  public partial class Collector:Node
  {
    [Export]
    public CollectorTypeFlag collectorTypeFlag;

    [Export]
    public CollectableCollection[] collectables = [];

    [Export]
    public bool canAutoCollect = true;

    [Export]
    public CollectableData lastItemData;

    [Export]
    public ISOTimeStamp lastItemTime;

    [Export]
    public Action onCollected;

    public bool CanCollect( Collectable collectable )
    {
      if ( canAutoCollect && collectable.isAutoCollectable )
      {
        return true;
      }

      return collectables.Has( c => c.collectableType == collectable.collectableData.collectableType );
    } 

    public virtual bool Collect( Collectable collectable )
    {
      var canCollect = CanCollect( collectable  );

      if ( ! canCollect )
      {
        return false;
      }

      var collection = collectables.Find( c => c.collectableType == collectable.collectableData.collectableType );

      if ( collection == null )
      {
        collection = new CollectableCollection();
        collection.collectableType = collectable.collectableData.collectableType;

        collectables = collectables.Add( collection );
      }

      lastItemData = collectable.collectableData;
      lastItemTime = ISOTimeStamp.Now();

      collection.collection = collection.collection.Add( lastItemData );
      collection.timeStamps = collection.timeStamps.Add( lastItemTime );

      onCollected?.Trigger();

      return true;
    }
  }
}
