using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;
using System.Drawing;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Collectable.svg")]
  public partial class OnCollected:Action
  {
    [Export]
    public Collector collector;

    [Export]
    public CollectableTypeGroup[] includingTypes = [];
    
    [Export]
    public CollectableTypeGroup[] excludingTypes = [];

    [Export]
    public Action onCollectedAction;

    protected override void _OnTrigger()
    {
      var collector = this.collector != null ? this.collector : this.FindParentThatIs<Collector>();

      if ( collector == null )
      {
        return;
      }

      var collectableData = collector.lastItemData;

      if ( collectableData == null )
      {
        return;
      }

      if ( includingTypes != null )
      {
        var included = includingTypes.Has( g => g.types.Has( t => t == collectableData.collectableType ) );

        if ( ! included )
        {
          return;
        }
      }

      if ( excludingTypes != null )
      {
        var excluded = excludingTypes.Has( g => g.types.Has( t => t == collectableData.collectableType ) );

        if ( excluded )
        {
          return;
        }
      }


      onCollectedAction?.Trigger();

    }

  }
}
