using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;
using System.Drawing;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Grabbable.svg")]
  public partial class Grabbable:Node3D, iEnablable
  {
    
    [Export]
    public bool enabled = true;
    public bool IsEnabled() => enabled;
    public void SetEnabled( bool enabled ) { this.enabled = enabled; }

    
    [Export]
    public Action onGrab;

    [Export]
    public Action onRelease;

    [Export]
    public Node3D grabTarget;

    [Export]
    public RigidBody3D rigidBody3D;
    
    [Export]
    public Pointable pointable;


    bool _disablePointableDuringGrab;
    [Export]
    public bool disablePointableDuringGrab
    {
      get => _disablePointableDuringGrab;
      set 
      {
        _disablePointableDuringGrab = value;

        #if TOOLS
        UpdateConfigurationWarnings();
        #endif
      }
    }

    [ExportGroup("Read Only")]
    [Export]
    public Grabber grabber;

    protected bool enablePointableOnRelease = false;

    public override string[] _GetConfigurationWarnings()
    {
      var warnigns = new List<string>();

      if ( grabTarget == null )
      {
        warnigns.Add( HierarchyName.Of( this ) + ":" + "No grabTarget assigned.");
      }

      if ( rigidBody3D == null )
      {
        warnigns.Add( HierarchyName.Of( this ) + ":" + "No rigidBody3D assigned.");
      }

      if ( pointable == null && _disablePointableDuringGrab )
      {
        warnigns.Add( HierarchyName.Of( this ) + ":" + "No pointable assigned, although 'disablePointableDuringGrab' is active.");
      }

      return warnigns.ToArray();
    }

    public void SetGrabber( Grabber grabber )
    {
      this.grabber = grabber;

     
      if ( grabber != null && ( disablePointableDuringGrab || grabber.disablePointableDuringGrab ) )
      {
        if ( pointable == null )
        {
          pointable = this.FindSibling<Pointable>();
        }

        if ( pointable != null )
        {
          pointable.enabled = false;  
          enablePointableOnRelease = true;
        }
      }

      if ( grabber == null )
      {
        if ( pointable != null && enablePointableOnRelease )
        {
          pointable.enabled = true;
        }

        enablePointableOnRelease = false;
      }

      if ( this.grabber != null )
      {
        Action.Trigger( onGrab );
      }
      else
      {
        Action.Trigger( onRelease );
      }
      
    }
  

  }
}