using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;

namespace Rokojori
{
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Interactor.svg")]
  public partial class Interactor:Node3D, SensorInputHandler
  {
    [Export]
    public Pointer pointer;

    [Export]
    public Sensor button;

    [Export]
    public Action onInteract;

    public override void _Ready()
    {
      SensorManager.Register( this, button );
    }

    public override void _ExitTree()
    {
      SensorManager.Unregister( this, button );
    }

    public void _OnSensor( SensorEvent se )
    {

      if ( pointer == null || pointer.pointable == null )
      {
        return;
      }

      if ( ! se.isDown )
      {
        return;
      }

      var interactable = Nodes.Find<Interactable>( pointer.pointable.GetParent() );

      if ( interactable == null )
      {
        
        return;
      }

      Action.Trigger( interactable.onInteraction );
    }
  }
}