using Godot;
using System.Collections;
using System.Collections.Generic;
using Godot.Collections;
using System.Drawing;

namespace Rokojori
{ 
  [Tool]
  [GlobalClass,Icon("res://addons/rokojori_action_library/Icons/Pointer.svg")]
  public partial class Pointer:Action
  {
    [Export]
    public Caster caster;

    [Export]
    public HighlightEffect defaultHighlighter;

    [ExportGroup("Read Only")]
    [Export]
    public Pointable pointable;


    public readonly EventSlot<Pointable> onPointerChange = new EventSlot<Pointable>();


    [Export]
    public bool printPointables = false;

    protected override void _OnTrigger()
    { 
      if ( caster == null )
      {
        return;
      }

      var currentCollider = caster.NumColliders() == 0 ? null : caster.GetCollider( 0 );


      var currentPointable =  currentCollider == null ? null : Nodes.Find<Pointable>( currentCollider );

      // RJLog.Log( currentCollider, currentPointable );

      if ( currentPointable == pointable )
      {
        return;
      }

      
      if ( pointable != null )
      {        
        pointable.UpdatePointerState( this, false );
        Highlight( HighlightActionType.End, pointable );
      }

      pointable = currentPointable;

      if ( pointable != null )
      {        
        pointable.UpdatePointerState( this, true );        
        Highlight( HighlightActionType.Start, pointable );
      }

      onPointerChange.DispatchEvent( currentPointable );

      if ( printPointables )
      {
        this.LogInfo( pointable );
      }
    }

    void Highlight( HighlightActionType type, Pointable p )
    {
      if ( p.highlightTargets == null || p.highlightTargets.Length == 0  )
      {
        return;
      }

      if ( p.highlightEffect == null && defaultHighlighter == null )
      {
        return;
      }


      var highlightEffect = p.highlightEffect ?? defaultHighlighter;
      // this.LogInfo( "Set Highlight", highlightEffect == null ? "<null>" : HierarchyName.Of( highlightEffect ) );

      highlightEffect.Highlight( type, p.highlightTargets );
    
    }
  }
}